-- To add a section to the credits, use the following:
-- local theme_credits= {
-- 	name= "Theme Credits", -- the name of your section
-- 	"Me", -- The people you want to list in your section.
-- 	"Myself",
-- 	"My other self",
--  {logo= "pro_dude", name= "Pro self"}, -- Someone who has a logo image.
--     -- This logo image would be "Graphics/CreditsLogo pro_dude.png".
-- }
-- StepManiaCredits.AddSection(theme_credits)
--
-- If you want to add your section after an existing section, use the following:
-- StepManiaCredits.AddSection(theme_credits, 7)
--
-- Or position can be the name of a section to insert after:
-- StepManiaCredits.AddSection(theme_credits, "Special Thanks")
--
-- Or if you want to add your section before a section:
-- StepManiaCredits.AddSection(theme_credits, "Special Thanks", true)

local tm3_staff = {
	name= "TrotMania III Staff",
 	"Lirodon",
	"RIME (DDR Addict)",
	"Dreamland200"
	};

local tm3_steppers = {
	name= "Chart Team",
 	"Dreamland200",
	"RIME",
	"Tesselode",
	"Supersaw Hoover",
	"Lirodon",
	};

local tm3_artists = {
	name= "Contributing artists",
 	"Bumblebun",
	"Eiraesy",
	"Sir-CoffeeBean",
	"ThisGuy2146",
	"Yoru-no-Seishin",
	};

local tm3_vectors = {
	name= "Also featuring the artistic talent of...",
 	"LPSFreak",
	"Sulyo",
	"3luk",
	"GameMasterLuna",
	"reynaruina",
	"electablecoffee",
	"NotLikelyAnArtist",
	"HankOfficer",
	"iamadinosaurrarrr",
	"Masem",
	"dacowta",
	"kysss90",
	"spier17",
	"Grey-Gold",
	"tamalesyatole",
	"katequantum",
	"minipones",
	"triox404",
	"Lextsy",
	"spinnyhat",
	"cl0setbr0ny",
	"lman225",
	"lukezke",
	"And others...",
	};
	
local tm3_thanks = {
	name= "Special thanks to...",
 	{logo= "pvfm", name= "Official Sponsor and Host"},
	{logo= "ziv", name= "Hosting and Development Platform"},
	{logo= "brcz", name= "Our European Supporters"},
	"And you, for playing!",
	"The rest of the StepMania team:",
	};

StepManiaCredits.AddSection(tm3_staff, 1);
StepManiaCredits.AddSection(tm3_steppers, 2);
StepManiaCredits.AddSection(tm3_artists, 3);
StepManiaCredits.AddSection(tm3_vectors, 4);
StepManiaCredits.AddSection(tm3_thanks, 5);
	
-- StepManiaCredits is defined in _fallback/Scripts/04 CreditsHelpers.lua.

local line_on = cmd(zoom,0.875;strokecolor,color("#444444");shadowcolor,color("#444444");shadowlength,1)
local section_on = cmd(diffuse,color("#88DDFF");strokecolor,color("#446688");shadowcolor,color("#446688");shadowlength,1)
local subsection_on = cmd(diffuse,color("#88DDFF");strokecolor,color("#446688");shadowcolor,color("#446688");shadowlength,1)
local item_padding_start = 4;
local line_height= 30
-- Tell the credits table the line height so it can use it for logo sizing.
StepManiaCredits.SetLineHeight(line_height)


local creditScroller = Def.ActorScroller {
	SecondsPerItem = 0.4;
	NumItemsToDraw = 40;
	TransformFunction = function( self, offset, itemIndex, numItems)
		self:y(line_height*offset)
	end;
	OnCommand = cmd(scrollwithpadding,item_padding_start,15);
}

-- Add sections with padding.
for section in ivalues(StepManiaCredits.Get()) do
	StepManiaCredits.AddLineToScroller(creditScroller, section.name, section_on)
	for name in ivalues(section) do
		if name.type == "subsection" then
			StepManiaCredits.AddLineToScroller(creditScroller, name, subsection_on)
		else
			StepManiaCredits.AddLineToScroller(creditScroller, name, line_on)
		end
	end
	StepManiaCredits.AddLineToScroller(creditScroller)
	StepManiaCredits.AddLineToScroller(creditScroller)
end

creditScroller.BeginCommand=function(self)
	SCREENMAN:GetTopScreen():PostScreenMessage( 'SM_MenuTimer', (creditScroller.SecondsPerItem * (#creditScroller + item_padding_start) + 10) );
end;

return Def.ActorFrame{
	creditScroller..{
		InitCommand=cmd(CenterX;y,SCREEN_BOTTOM-64),
	}
};
